// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MigrationDiscoverySap.Models
{
    /// <summary> Select the database if this is a database server. Leave blank or add Not Applicable for all other instances except the Database Instance. </summary>
    public readonly partial struct SapDiscoveryDatabaseType : IEquatable<SapDiscoveryDatabaseType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SapDiscoveryDatabaseType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SapDiscoveryDatabaseType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AdabasValue = "Adabas";
        private const string OracleValue = "Oracle";
        private const string SapMaxDBValue = "SAPMaxDB";
        private const string DB2Value = "Db2";
        private const string SapAseValue = "SAPASE";
        private const string SQLServerValue = "SQLServer";
        private const string InformixValue = "Informix";
        private const string SapDBValue = "SAPDB";
        private const string HanaValue = "HANA";

        /// <summary> The type of Database- Adabas. </summary>
        public static SapDiscoveryDatabaseType Adabas { get; } = new SapDiscoveryDatabaseType(AdabasValue);
        /// <summary> The type of Database- Oracle. </summary>
        public static SapDiscoveryDatabaseType Oracle { get; } = new SapDiscoveryDatabaseType(OracleValue);
        /// <summary> The type of Database- SAPMaxDB. </summary>
        public static SapDiscoveryDatabaseType SapMaxDB { get; } = new SapDiscoveryDatabaseType(SapMaxDBValue);
        /// <summary> The type of Database- Db2. </summary>
        public static SapDiscoveryDatabaseType DB2 { get; } = new SapDiscoveryDatabaseType(DB2Value);
        /// <summary> The type of Database- SAPASE. </summary>
        public static SapDiscoveryDatabaseType SapAse { get; } = new SapDiscoveryDatabaseType(SapAseValue);
        /// <summary> The type of Database- SQLServer. </summary>
        public static SapDiscoveryDatabaseType SQLServer { get; } = new SapDiscoveryDatabaseType(SQLServerValue);
        /// <summary> The type of Database- Informix. </summary>
        public static SapDiscoveryDatabaseType Informix { get; } = new SapDiscoveryDatabaseType(InformixValue);
        /// <summary> The type of Database- SAPDB. </summary>
        public static SapDiscoveryDatabaseType SapDB { get; } = new SapDiscoveryDatabaseType(SapDBValue);
        /// <summary> The type of Database- HANA. </summary>
        public static SapDiscoveryDatabaseType Hana { get; } = new SapDiscoveryDatabaseType(HanaValue);
        /// <summary> Determines if two <see cref="SapDiscoveryDatabaseType"/> values are the same. </summary>
        public static bool operator ==(SapDiscoveryDatabaseType left, SapDiscoveryDatabaseType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SapDiscoveryDatabaseType"/> values are not the same. </summary>
        public static bool operator !=(SapDiscoveryDatabaseType left, SapDiscoveryDatabaseType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SapDiscoveryDatabaseType"/>. </summary>
        public static implicit operator SapDiscoveryDatabaseType(string value) => new SapDiscoveryDatabaseType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SapDiscoveryDatabaseType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SapDiscoveryDatabaseType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
