// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MigrationDiscoverySap.Models
{
    /// <summary> The data source for this resource. </summary>
    internal readonly partial struct SapDiscoveryDataSource : IEquatable<SapDiscoveryDataSource>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SapDiscoveryDataSource"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SapDiscoveryDataSource(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ExcelValue = "Excel";
        private const string NativeValue = "Native";

        /// <summary> The type of DataSource- Excel. </summary>
        public static SapDiscoveryDataSource Excel { get; } = new SapDiscoveryDataSource(ExcelValue);
        /// <summary> The type of DataSource- Native. </summary>
        public static SapDiscoveryDataSource Native { get; } = new SapDiscoveryDataSource(NativeValue);
        /// <summary> Determines if two <see cref="SapDiscoveryDataSource"/> values are the same. </summary>
        public static bool operator ==(SapDiscoveryDataSource left, SapDiscoveryDataSource right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SapDiscoveryDataSource"/> values are not the same. </summary>
        public static bool operator !=(SapDiscoveryDataSource left, SapDiscoveryDataSource right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SapDiscoveryDataSource"/>. </summary>
        public static implicit operator SapDiscoveryDataSource(string value) => new SapDiscoveryDataSource(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SapDiscoveryDataSource other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SapDiscoveryDataSource other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
