// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MigrationDiscoverySap.Models
{
    [PersistableModelProxy(typeof(UnknownPerformanceData))]
    public partial class PerformanceDetail : IUtf8JsonSerializable, IJsonModel<PerformanceDetail>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PerformanceDetail>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PerformanceDetail>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PerformanceDetail>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PerformanceDetail)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("dataSource"u8);
            writer.WriteStringValue(DataSource.ToString());
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PerformanceDetail IJsonModel<PerformanceDetail>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PerformanceDetail>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PerformanceDetail)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePerformanceDetail(document.RootElement, options);
        }

        internal static PerformanceDetail DeserializePerformanceDetail(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("dataSource", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "Excel": return ExcelPerformanceDetail.DeserializeExcelPerformanceDetail(element, options);
                    case "Native": return NativePerformanceDetail.DeserializeNativePerformanceDetail(element, options);
                }
            }
            return UnknownPerformanceData.DeserializeUnknownPerformanceData(element, options);
        }

        BinaryData IPersistableModel<PerformanceDetail>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PerformanceDetail>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(PerformanceDetail)} does not support writing '{options.Format}' format.");
            }
        }

        PerformanceDetail IPersistableModel<PerformanceDetail>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PerformanceDetail>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePerformanceDetail(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PerformanceDetail)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PerformanceDetail>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
