// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MigrationDiscoverySap.Models
{
    public partial class ExcelPerformanceDetail : IUtf8JsonSerializable, IJsonModel<ExcelPerformanceDetail>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ExcelPerformanceDetail>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ExcelPerformanceDetail>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExcelPerformanceDetail>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ExcelPerformanceDetail)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(MaxCpuLoad))
            {
                writer.WritePropertyName("maxCpuLoad"u8);
                writer.WriteNumberValue(MaxCpuLoad.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TotalSourceDbSizeGB))
            {
                writer.WritePropertyName("totalSourceDbSizeGB"u8);
                writer.WriteNumberValue(TotalSourceDbSizeGB.Value);
            }
        }

        ExcelPerformanceDetail IJsonModel<ExcelPerformanceDetail>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExcelPerformanceDetail>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ExcelPerformanceDetail)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeExcelPerformanceDetail(document.RootElement, options);
        }

        internal static ExcelPerformanceDetail DeserializeExcelPerformanceDetail(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? maxCpuLoad = default;
            int? totalSourceDbSizeGB = default;
            SapDiscoveryDataSource dataSource = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("maxCpuLoad"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxCpuLoad = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("totalSourceDbSizeGB"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalSourceDbSizeGB = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("dataSource"u8))
                {
                    dataSource = new SapDiscoveryDataSource(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ExcelPerformanceDetail(dataSource, serializedAdditionalRawData, maxCpuLoad, totalSourceDbSizeGB);
        }

        BinaryData IPersistableModel<ExcelPerformanceDetail>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExcelPerformanceDetail>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ExcelPerformanceDetail)} does not support writing '{options.Format}' format.");
            }
        }

        ExcelPerformanceDetail IPersistableModel<ExcelPerformanceDetail>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExcelPerformanceDetail>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeExcelPerformanceDetail(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ExcelPerformanceDetail)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ExcelPerformanceDetail>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
