// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MigrationDiscoverySap.Models
{
    public partial class ConfigurationDetail : IUtf8JsonSerializable, IJsonModel<ConfigurationDetail>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ConfigurationDetail>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ConfigurationDetail>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConfigurationDetail>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConfigurationDetail)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(Saps))
            {
                writer.WritePropertyName("saps"u8);
                writer.WriteNumberValue(Saps.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(Cpu))
            {
                writer.WritePropertyName("cpu"u8);
                writer.WriteNumberValue(Cpu.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(CpuType))
            {
                writer.WritePropertyName("cpuType"u8);
                writer.WriteStringValue(CpuType);
            }
            if (options.Format != "W" && Optional.IsDefined(CpuInMhz))
            {
                writer.WritePropertyName("cpuInMhz"u8);
                writer.WriteNumberValue(CpuInMhz.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(Ram))
            {
                writer.WritePropertyName("ram"u8);
                writer.WriteNumberValue(Ram.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(HardwareManufacturer))
            {
                writer.WritePropertyName("hardwareManufacturer"u8);
                writer.WriteStringValue(HardwareManufacturer);
            }
            if (options.Format != "W" && Optional.IsDefined(Model))
            {
                writer.WritePropertyName("model"u8);
                writer.WriteStringValue(Model);
            }
            if (options.Format != "W" && Optional.IsDefined(TotalDiskSizeGB))
            {
                writer.WritePropertyName("totalDiskSizeGB"u8);
                writer.WriteNumberValue(TotalDiskSizeGB.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TotalDiskIops))
            {
                writer.WritePropertyName("totalDiskIops"u8);
                writer.WriteNumberValue(TotalDiskIops.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(DatabaseType))
            {
                writer.WritePropertyName("databaseType"u8);
                writer.WriteStringValue(DatabaseType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(TargetHanaRamSizeGB))
            {
                writer.WritePropertyName("targetHanaRamSizeGB"u8);
                writer.WriteNumberValue(TargetHanaRamSizeGB.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ConfigurationDetail IJsonModel<ConfigurationDetail>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConfigurationDetail>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConfigurationDetail)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeConfigurationDetail(document.RootElement, options);
        }

        internal static ConfigurationDetail DeserializeConfigurationDetail(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? saps = default;
            int? cpu = default;
            string cpuType = default;
            int? cpuInMhz = default;
            int? ram = default;
            string hardwareManufacturer = default;
            string model = default;
            int? totalDiskSizeGB = default;
            int? totalDiskIops = default;
            SapDiscoveryDatabaseType? databaseType = default;
            int? targetHanaRamSizeGB = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("saps"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    saps = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("cpu"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cpu = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("cpuType"u8))
                {
                    cpuType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("cpuInMhz"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cpuInMhz = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("ram"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ram = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("hardwareManufacturer"u8))
                {
                    hardwareManufacturer = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("model"u8))
                {
                    model = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("totalDiskSizeGB"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalDiskSizeGB = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("totalDiskIops"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalDiskIops = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("databaseType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    databaseType = new SapDiscoveryDatabaseType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("targetHanaRamSizeGB"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    targetHanaRamSizeGB = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ConfigurationDetail(
                saps,
                cpu,
                cpuType,
                cpuInMhz,
                ram,
                hardwareManufacturer,
                model,
                totalDiskSizeGB,
                totalDiskIops,
                databaseType,
                targetHanaRamSizeGB,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ConfigurationDetail>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConfigurationDetail>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ConfigurationDetail)} does not support writing '{options.Format}' format.");
            }
        }

        ConfigurationDetail IPersistableModel<ConfigurationDetail>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConfigurationDetail>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeConfigurationDetail(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ConfigurationDetail)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ConfigurationDetail>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
