// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MigrationDiscoverySap
{
    internal class SapDiscoveryServerInstanceOperationSource : IOperationSource<SapDiscoveryServerInstanceResource>
    {
        private readonly ArmClient _client;

        internal SapDiscoveryServerInstanceOperationSource(ArmClient client)
        {
            _client = client;
        }

        SapDiscoveryServerInstanceResource IOperationSource<SapDiscoveryServerInstanceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SapDiscoveryServerInstanceData.DeserializeSapDiscoveryServerInstanceData(document.RootElement);
            return new SapDiscoveryServerInstanceResource(_client, data);
        }

        async ValueTask<SapDiscoveryServerInstanceResource> IOperationSource<SapDiscoveryServerInstanceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SapDiscoveryServerInstanceData.DeserializeSapDiscoveryServerInstanceData(document.RootElement);
            return new SapDiscoveryServerInstanceResource(_client, data);
        }
    }
}
