// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Threading;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.MigrationDiscoverySap.Mocking
{
    /// <summary> A class to add extension methods to SubscriptionResource. </summary>
    public partial class MockableMigrationDiscoverySapSubscriptionResource : ArmResource
    {
        private ClientDiagnostics _sapDiscoverySiteClientDiagnostics;
        private SapDiscoverySitesRestOperations _sapDiscoverySiteRestClient;

        /// <summary> Initializes a new instance of the <see cref="MockableMigrationDiscoverySapSubscriptionResource"/> class for mocking. </summary>
        protected MockableMigrationDiscoverySapSubscriptionResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableMigrationDiscoverySapSubscriptionResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableMigrationDiscoverySapSubscriptionResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private ClientDiagnostics SapDiscoverySiteClientDiagnostics => _sapDiscoverySiteClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.MigrationDiscoverySap", SapDiscoverySiteResource.ResourceType.Namespace, Diagnostics);
        private SapDiscoverySitesRestOperations SapDiscoverySiteRestClient => _sapDiscoverySiteRestClient ??= new SapDiscoverySitesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, GetApiVersionOrNull(SapDiscoverySiteResource.ResourceType));

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets all SAP Migration discovery site resources in a Subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Workloads/sapDiscoverySites</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SapDiscoverySites_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SapDiscoverySiteResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SapDiscoverySiteResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SapDiscoverySiteResource> GetSapDiscoverySitesAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => SapDiscoverySiteRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => SapDiscoverySiteRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SapDiscoverySiteResource(Client, SapDiscoverySiteData.DeserializeSapDiscoverySiteData(e)), SapDiscoverySiteClientDiagnostics, Pipeline, "MockableMigrationDiscoverySapSubscriptionResource.GetSapDiscoverySites", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets all SAP Migration discovery site resources in a Subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Workloads/sapDiscoverySites</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SapDiscoverySites_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SapDiscoverySiteResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SapDiscoverySiteResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SapDiscoverySiteResource> GetSapDiscoverySites(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => SapDiscoverySiteRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => SapDiscoverySiteRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SapDiscoverySiteResource(Client, SapDiscoverySiteData.DeserializeSapDiscoverySiteData(e)), SapDiscoverySiteClientDiagnostics, Pipeline, "MockableMigrationDiscoverySapSubscriptionResource.GetSapDiscoverySites", "value", "nextLink", cancellationToken);
        }
    }
}
