// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MigrationDiscoverySap.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableMigrationDiscoverySapResourceGroupResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableMigrationDiscoverySapResourceGroupResource"/> class for mocking. </summary>
        protected MockableMigrationDiscoverySapResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableMigrationDiscoverySapResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableMigrationDiscoverySapResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of SapDiscoverySiteResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of SapDiscoverySiteResources and their operations over a SapDiscoverySiteResource. </returns>
        public virtual SapDiscoverySiteCollection GetSapDiscoverySites()
        {
            return GetCachedClient(client => new SapDiscoverySiteCollection(client, Id));
        }

        /// <summary>
        /// Gets a SAP Migration discovery site resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SapDiscoverySites_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SapDiscoverySiteResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sapDiscoverySiteName"> The name of the discovery site resource for SAP Migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sapDiscoverySiteName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sapDiscoverySiteName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<SapDiscoverySiteResource>> GetSapDiscoverySiteAsync(string sapDiscoverySiteName, CancellationToken cancellationToken = default)
        {
            return await GetSapDiscoverySites().GetAsync(sapDiscoverySiteName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets a SAP Migration discovery site resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SapDiscoverySites_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SapDiscoverySiteResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sapDiscoverySiteName"> The name of the discovery site resource for SAP Migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sapDiscoverySiteName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sapDiscoverySiteName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<SapDiscoverySiteResource> GetSapDiscoverySite(string sapDiscoverySiteName, CancellationToken cancellationToken = default)
        {
            return GetSapDiscoverySites().Get(sapDiscoverySiteName, cancellationToken);
        }
    }
}
