// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.MigrationDiscoverySap.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableMigrationDiscoverySapArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableMigrationDiscoverySapArmClient"/> class for mocking. </summary>
        protected MockableMigrationDiscoverySapArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableMigrationDiscoverySapArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableMigrationDiscoverySapArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableMigrationDiscoverySapArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="SapDiscoverySiteResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SapDiscoverySiteResource.CreateResourceIdentifier" /> to create a <see cref="SapDiscoverySiteResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SapDiscoverySiteResource"/> object. </returns>
        public virtual SapDiscoverySiteResource GetSapDiscoverySiteResource(ResourceIdentifier id)
        {
            SapDiscoverySiteResource.ValidateResourceId(id);
            return new SapDiscoverySiteResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SapInstanceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SapInstanceResource.CreateResourceIdentifier" /> to create a <see cref="SapInstanceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SapInstanceResource"/> object. </returns>
        public virtual SapInstanceResource GetSapInstanceResource(ResourceIdentifier id)
        {
            SapInstanceResource.ValidateResourceId(id);
            return new SapInstanceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SapDiscoveryServerInstanceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SapDiscoveryServerInstanceResource.CreateResourceIdentifier" /> to create a <see cref="SapDiscoveryServerInstanceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SapDiscoveryServerInstanceResource"/> object. </returns>
        public virtual SapDiscoveryServerInstanceResource GetSapDiscoveryServerInstanceResource(ResourceIdentifier id)
        {
            SapDiscoveryServerInstanceResource.ValidateResourceId(id);
            return new SapDiscoveryServerInstanceResource(Client, id);
        }
    }
}
