// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.MigrationDiscoverySap.Mocking;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.MigrationDiscoverySap
{
    /// <summary> A class to add extension methods to Azure.ResourceManager.MigrationDiscoverySap. </summary>
    public static partial class MigrationDiscoverySapExtensions
    {
        private static MockableMigrationDiscoverySapArmClient GetMockableMigrationDiscoverySapArmClient(ArmClient client)
        {
            return client.GetCachedClient(client0 => new MockableMigrationDiscoverySapArmClient(client0));
        }

        private static MockableMigrationDiscoverySapResourceGroupResource GetMockableMigrationDiscoverySapResourceGroupResource(ArmResource resource)
        {
            return resource.GetCachedClient(client => new MockableMigrationDiscoverySapResourceGroupResource(client, resource.Id));
        }

        private static MockableMigrationDiscoverySapSubscriptionResource GetMockableMigrationDiscoverySapSubscriptionResource(ArmResource resource)
        {
            return resource.GetCachedClient(client => new MockableMigrationDiscoverySapSubscriptionResource(client, resource.Id));
        }

        /// <summary>
        /// Gets an object representing a <see cref="SapDiscoverySiteResource" /> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SapDiscoverySiteResource.CreateResourceIdentifier" /> to create a <see cref="SapDiscoverySiteResource" /> <see cref="ResourceIdentifier" /> from its components.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableMigrationDiscoverySapArmClient.GetSapDiscoverySiteResource(ResourceIdentifier)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> is null. </exception>
        /// <returns> Returns a <see cref="SapDiscoverySiteResource"/> object. </returns>
        public static SapDiscoverySiteResource GetSapDiscoverySiteResource(this ArmClient client, ResourceIdentifier id)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableMigrationDiscoverySapArmClient(client).GetSapDiscoverySiteResource(id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SapInstanceResource" /> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SapInstanceResource.CreateResourceIdentifier" /> to create a <see cref="SapInstanceResource" /> <see cref="ResourceIdentifier" /> from its components.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableMigrationDiscoverySapArmClient.GetSapInstanceResource(ResourceIdentifier)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> is null. </exception>
        /// <returns> Returns a <see cref="SapInstanceResource"/> object. </returns>
        public static SapInstanceResource GetSapInstanceResource(this ArmClient client, ResourceIdentifier id)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableMigrationDiscoverySapArmClient(client).GetSapInstanceResource(id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SapDiscoveryServerInstanceResource" /> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SapDiscoveryServerInstanceResource.CreateResourceIdentifier" /> to create a <see cref="SapDiscoveryServerInstanceResource" /> <see cref="ResourceIdentifier" /> from its components.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableMigrationDiscoverySapArmClient.GetSapDiscoveryServerInstanceResource(ResourceIdentifier)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> is null. </exception>
        /// <returns> Returns a <see cref="SapDiscoveryServerInstanceResource"/> object. </returns>
        public static SapDiscoveryServerInstanceResource GetSapDiscoveryServerInstanceResource(this ArmClient client, ResourceIdentifier id)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableMigrationDiscoverySapArmClient(client).GetSapDiscoveryServerInstanceResource(id);
        }

        /// <summary>
        /// Gets a collection of SapDiscoverySiteResources in the ResourceGroupResource.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableMigrationDiscoverySapResourceGroupResource.GetSapDiscoverySites()"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="resourceGroupResource"> The <see cref="ResourceGroupResource" /> instance the method will execute against. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceGroupResource"/> is null. </exception>
        /// <returns> An object representing collection of SapDiscoverySiteResources and their operations over a SapDiscoverySiteResource. </returns>
        public static SapDiscoverySiteCollection GetSapDiscoverySites(this ResourceGroupResource resourceGroupResource)
        {
            Argument.AssertNotNull(resourceGroupResource, nameof(resourceGroupResource));

            return GetMockableMigrationDiscoverySapResourceGroupResource(resourceGroupResource).GetSapDiscoverySites();
        }

        /// <summary>
        /// Gets a SAP Migration discovery site resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SapDiscoverySites_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SapDiscoverySiteResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableMigrationDiscoverySapResourceGroupResource.GetSapDiscoverySiteAsync(string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="resourceGroupResource"> The <see cref="ResourceGroupResource" /> instance the method will execute against. </param>
        /// <param name="sapDiscoverySiteName"> The name of the discovery site resource for SAP Migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceGroupResource"/> or <paramref name="sapDiscoverySiteName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sapDiscoverySiteName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public static async Task<Response<SapDiscoverySiteResource>> GetSapDiscoverySiteAsync(this ResourceGroupResource resourceGroupResource, string sapDiscoverySiteName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(resourceGroupResource, nameof(resourceGroupResource));

            return await GetMockableMigrationDiscoverySapResourceGroupResource(resourceGroupResource).GetSapDiscoverySiteAsync(sapDiscoverySiteName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets a SAP Migration discovery site resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SapDiscoverySites_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SapDiscoverySiteResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableMigrationDiscoverySapResourceGroupResource.GetSapDiscoverySite(string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="resourceGroupResource"> The <see cref="ResourceGroupResource" /> instance the method will execute against. </param>
        /// <param name="sapDiscoverySiteName"> The name of the discovery site resource for SAP Migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceGroupResource"/> or <paramref name="sapDiscoverySiteName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sapDiscoverySiteName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public static Response<SapDiscoverySiteResource> GetSapDiscoverySite(this ResourceGroupResource resourceGroupResource, string sapDiscoverySiteName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(resourceGroupResource, nameof(resourceGroupResource));

            return GetMockableMigrationDiscoverySapResourceGroupResource(resourceGroupResource).GetSapDiscoverySite(sapDiscoverySiteName, cancellationToken);
        }

        /// <summary>
        /// Gets all SAP Migration discovery site resources in a Subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Workloads/sapDiscoverySites</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SapDiscoverySites_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SapDiscoverySiteResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableMigrationDiscoverySapSubscriptionResource.GetSapDiscoverySites(CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="subscriptionResource"> The <see cref="SubscriptionResource" /> instance the method will execute against. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionResource"/> is null. </exception>
        /// <returns> An async collection of <see cref="SapDiscoverySiteResource"/> that may take multiple service requests to iterate over. </returns>
        public static AsyncPageable<SapDiscoverySiteResource> GetSapDiscoverySitesAsync(this SubscriptionResource subscriptionResource, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(subscriptionResource, nameof(subscriptionResource));

            return GetMockableMigrationDiscoverySapSubscriptionResource(subscriptionResource).GetSapDiscoverySitesAsync(cancellationToken);
        }

        /// <summary>
        /// Gets all SAP Migration discovery site resources in a Subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Workloads/sapDiscoverySites</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SapDiscoverySites_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-10-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SapDiscoverySiteResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableMigrationDiscoverySapSubscriptionResource.GetSapDiscoverySites(CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="subscriptionResource"> The <see cref="SubscriptionResource" /> instance the method will execute against. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionResource"/> is null. </exception>
        /// <returns> A collection of <see cref="SapDiscoverySiteResource"/> that may take multiple service requests to iterate over. </returns>
        public static Pageable<SapDiscoverySiteResource> GetSapDiscoverySites(this SubscriptionResource subscriptionResource, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(subscriptionResource, nameof(subscriptionResource));

            return GetMockableMigrationDiscoverySapSubscriptionResource(subscriptionResource).GetSapDiscoverySites(cancellationToken);
        }
    }
}
