// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.MigrationDiscoverySap.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmMigrationDiscoverySapModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="MigrationDiscoverySap.SapDiscoverySiteData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="extendedLocation"> The extended location definition. </param>
        /// <param name="masterSiteId"> The master site ID from Azure Migrate. </param>
        /// <param name="migrateProjectId"> The migrate project ID from Azure Migrate. </param>
        /// <param name="provisioningState"> Defines the provisioning states. </param>
        /// <param name="errors"> Indicates any errors on the SAP Migration discovery site resource. </param>
        /// <returns> A new <see cref="MigrationDiscoverySap.SapDiscoverySiteData"/> instance for mocking. </returns>
        public static SapDiscoverySiteData SapDiscoverySiteData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, SapDiscoveryExtendedLocation extendedLocation = null, string masterSiteId = null, string migrateProjectId = null, SapDiscoveryProvisioningState? provisioningState = null, SapMigrateError errors = null)
        {
            tags ??= new Dictionary<string, string>();

            return new SapDiscoverySiteData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                extendedLocation,
                masterSiteId,
                migrateProjectId,
                provisioningState,
                errors,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SapMigrateError"/>. </summary>
        /// <param name="code"> Service specific error code which serves as the substatus for the HTTP error code. </param>
        /// <param name="message"> Description of the error. </param>
        /// <param name="recommendation"> Description of the recommendation. </param>
        /// <param name="details"> Internal error details. </param>
        /// <returns> A new <see cref="Models.SapMigrateError"/> instance for mocking. </returns>
        public static SapMigrateError SapMigrateError(string code = null, string message = null, string recommendation = null, IEnumerable<SapDiscoveryErrorDetail> details = null)
        {
            details ??= new List<SapDiscoveryErrorDetail>();

            return new SapMigrateError(code, message, recommendation, details?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SapDiscoveryErrorDetail"/>. </summary>
        /// <param name="code"> Service specific error code which serves as the substatus for the HTTP error code. </param>
        /// <param name="message"> Description of the error. </param>
        /// <param name="recommendation"> Description of the recommendation. </param>
        /// <param name="details"> Internal error details. </param>
        /// <returns> A new <see cref="Models.SapDiscoveryErrorDetail"/> instance for mocking. </returns>
        public static SapDiscoveryErrorDetail SapDiscoveryErrorDetail(string code = null, string message = null, string recommendation = null, IEnumerable<SapDiscoveryErrorDetail> details = null)
        {
            details ??= new List<SapDiscoveryErrorDetail>();

            return new SapDiscoveryErrorDetail(code, message, recommendation, details?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="MigrationDiscoverySap.SapInstanceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="systemSid"> This is the SID of SAP System. Keeping this not equal to ID as different landscapes can have repeated System SID IDs. </param>
        /// <param name="environment"> The Environment; PRD, QA, DEV, etc to which SAP system belongs to. Select from the list of available dropdown values. </param>
        /// <param name="landscapeSid"> This is the SID of the production system in a landscape.  An SAP system could itself be a production SID or a part of a landscape with a different Production SID. This field can be used to relate non-prod SIDs, other components, SID (WEBDISP) to the prod SID. Enter the value of Production SID. </param>
        /// <param name="application"> Enter a business function/department identifier to group multiple SIDs. </param>
        /// <param name="provisioningState"> Defines the provisioning states. </param>
        /// <param name="errors"> Defines the errors related to SAP Instance resource. </param>
        /// <returns> A new <see cref="MigrationDiscoverySap.SapInstanceData"/> instance for mocking. </returns>
        public static SapInstanceData SapInstanceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string systemSid = null, SapInstanceEnvironment? environment = null, string landscapeSid = null, string application = null, SapDiscoveryProvisioningState? provisioningState = null, SapMigrateError errors = null)
        {
            tags ??= new Dictionary<string, string>();

            return new SapInstanceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                systemSid,
                environment,
                landscapeSid,
                application,
                provisioningState,
                errors,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="MigrationDiscoverySap.SapDiscoveryServerInstanceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="serverName"> This is the Virtual Machine Name of the SAP system. Add all the virtual machines attached to an SAP system which you wish to migrate to Azure. Keeping this not equal to ID as for single tier all InstanceTypes would be on same server, leading to multiple resources with same servername. </param>
        /// <param name="sapInstanceType"> Defines the type SAP instance on this server instance. </param>
        /// <param name="instanceSid"> This is the Instance SID for ASCS/AP/DB instance.  An SAP system with HANA database for example could have a different SID for database Instance than that of ASCS instance. </param>
        /// <param name="sapProduct"> This is the SAP Application Component; e.g. SAP S/4HANA 2022, SAP ERP ENHANCE PACKAGE. </param>
        /// <param name="sapProductVersion"> Provide the product version of the SAP product. </param>
        /// <param name="operatingSystem"> This is Operating System on which the host server is running. </param>
        /// <param name="configurationData"> Configuration data for this server instance. </param>
        /// <param name="performanceData">
        /// Configuration data for this server instance.
        /// Please note <see cref="PerformanceDetail"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.ExcelPerformanceDetail"/> and <see cref="NativePerformanceDetail"/>.
        /// </param>
        /// <param name="provisioningState"> Defines the provisioning states. </param>
        /// <param name="errors"> Defines the errors related to SAP Instance resource. </param>
        /// <returns> A new <see cref="MigrationDiscoverySap.SapDiscoveryServerInstanceData"/> instance for mocking. </returns>
        public static SapDiscoveryServerInstanceData SapDiscoveryServerInstanceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string serverName = null, SapInstanceType? sapInstanceType = null, string instanceSid = null, string sapProduct = null, string sapProductVersion = null, SapDiscoveryOperatingSystem? operatingSystem = null, ConfigurationDetail configurationData = null, PerformanceDetail performanceData = null, SapDiscoveryProvisioningState? provisioningState = null, SapMigrateError errors = null)
        {
            return new SapDiscoveryServerInstanceData(
                id,
                name,
                resourceType,
                systemData,
                serverName,
                sapInstanceType,
                instanceSid,
                sapProduct,
                sapProductVersion,
                operatingSystem,
                configurationData,
                performanceData,
                provisioningState,
                errors,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServerInstanceProperties"/>. </summary>
        /// <param name="serverName"> This is the Virtual Machine Name of the SAP system. Add all the virtual machines attached to an SAP system which you wish to migrate to Azure. Keeping this not equal to ID as for single tier all InstanceTypes would be on same server, leading to multiple resources with same servername. </param>
        /// <param name="sapInstanceType"> Defines the type SAP instance on this server instance. </param>
        /// <param name="instanceSid"> This is the Instance SID for ASCS/AP/DB instance.  An SAP system with HANA database for example could have a different SID for database Instance than that of ASCS instance. </param>
        /// <param name="sapProduct"> This is the SAP Application Component; e.g. SAP S/4HANA 2022, SAP ERP ENHANCE PACKAGE. </param>
        /// <param name="sapProductVersion"> Provide the product version of the SAP product. </param>
        /// <param name="operatingSystem"> This is Operating System on which the host server is running. </param>
        /// <param name="configurationData"> Configuration data for this server instance. </param>
        /// <param name="performanceData">
        /// Configuration data for this server instance.
        /// Please note <see cref="PerformanceDetail"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.ExcelPerformanceDetail"/> and <see cref="NativePerformanceDetail"/>.
        /// </param>
        /// <param name="provisioningState"> Defines the provisioning states. </param>
        /// <param name="errors"> Defines the errors related to SAP Instance resource. </param>
        /// <returns> A new <see cref="Models.ServerInstanceProperties"/> instance for mocking. </returns>
        public static ServerInstanceProperties ServerInstanceProperties(string serverName = null, SapInstanceType? sapInstanceType = null, string instanceSid = null, string sapProduct = null, string sapProductVersion = null, SapDiscoveryOperatingSystem? operatingSystem = null, ConfigurationDetail configurationData = null, PerformanceDetail performanceData = null, SapDiscoveryProvisioningState? provisioningState = null, SapMigrateError errors = null)
        {
            return new ServerInstanceProperties(
                serverName,
                sapInstanceType,
                instanceSid,
                sapProduct,
                sapProductVersion,
                operatingSystem,
                configurationData,
                performanceData,
                provisioningState,
                errors,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConfigurationDetail"/>. </summary>
        /// <param name="saps"> Provide the SAPS for each server of the SAP system. This should be a non-zero value. For example, 1000. </param>
        /// <param name="cpu"> Provide the CPU value of the server. For example, 16, 32 etc. </param>
        /// <param name="cpuType"> Provide the CPU architecture type of the server. For example, Xeon Platinum 8171M, Xeon E5-2673 v3. </param>
        /// <param name="cpuInMhz"> Provide the CPU clock speed of the server in MHz. This should be a non-zero value. For example, 2100. </param>
        /// <param name="ram"> Provide the RAM of the server. This should be a non-zero value. For example, 256. </param>
        /// <param name="hardwareManufacturer"> Provide the HW manufacturer company of the server.  For example, Microsoft Corporation. </param>
        /// <param name="model"> Specify if the Hardware is a physical server or virtual machine. </param>
        /// <param name="totalDiskSizeGB"> Provide the total disk volume capacity in GB. Add the disk volume for each individual disks and provide the total sum in this field. </param>
        /// <param name="totalDiskIops"> Provide the total disk IOPS capacity. Add the disk volume for each individual disk and provide the sum total in this field. </param>
        /// <param name="databaseType"> The database of this is a server instance. Applicable only if SAP instance type for this server instance is 'DB'. </param>
        /// <param name="targetHanaRamSizeGB"> Provide the target HANA database size you need. Applicable only if SAP instance type for this server instance is 'DB' and you are migrating an AnyDb database to SAP S/4HANA. </param>
        /// <returns> A new <see cref="Models.ConfigurationDetail"/> instance for mocking. </returns>
        public static ConfigurationDetail ConfigurationDetail(int? saps = null, int? cpu = null, string cpuType = null, int? cpuInMhz = null, int? ram = null, string hardwareManufacturer = null, string model = null, int? totalDiskSizeGB = null, int? totalDiskIops = null, SapDiscoveryDatabaseType? databaseType = null, int? targetHanaRamSizeGB = null)
        {
            return new ConfigurationDetail(
                saps,
                cpu,
                cpuType,
                cpuInMhz,
                ram,
                hardwareManufacturer,
                model,
                totalDiskSizeGB,
                totalDiskIops,
                databaseType,
                targetHanaRamSizeGB,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExcelPerformanceDetail"/>. </summary>
        /// <param name="maxCpuLoad"> Provide the max CPU percentage load on the server. Omit the percentage symbol while filling this value. </param>
        /// <param name="totalSourceDbSizeGB"> Provide the source Database size in GB. Applicable only if SAP instance type for this server instance is 'DB'. </param>
        /// <returns> A new <see cref="Models.ExcelPerformanceDetail"/> instance for mocking. </returns>
        public static ExcelPerformanceDetail ExcelPerformanceDetail(int? maxCpuLoad = null, int? totalSourceDbSizeGB = null)
        {
            return new ExcelPerformanceDetail(SapDiscoveryDataSource.Excel, serializedAdditionalRawData: null, maxCpuLoad, totalSourceDbSizeGB);
        }
    }
}
