// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.MigrationDiscoverySap.Models;

namespace Azure.ResourceManager.MigrationDiscoverySap.Samples
{
    public partial class Sample_SapDiscoveryServerInstanceResource
    {
        // GET a Server Instance resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GETAServerInstanceResource()
        {
            // Generated from example definition: specification/workloads/resource-manager/Microsoft.Workloads/SAPDiscoverySites/preview/2023-10-01-preview/examples/ServerInstances_Get.json
            // this example is just showing the usage of "ServerInstances_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SapDiscoveryServerInstanceResource created on azure
            // for more information of creating SapDiscoveryServerInstanceResource, please refer to the document of SapDiscoveryServerInstanceResource
            string subscriptionId = "6d875e77-e412-4d7d-9af4-8895278b4443";
            string resourceGroupName = "test-rg";
            string sapDiscoverySiteName = "SampleSite";
            string sapInstanceName = "MPP_MPP";
            string serverInstanceName = "APP_SapServer1";
            ResourceIdentifier sapDiscoveryServerInstanceResourceId = SapDiscoveryServerInstanceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, sapDiscoverySiteName, sapInstanceName, serverInstanceName);
            SapDiscoveryServerInstanceResource sapDiscoveryServerInstance = client.GetSapDiscoveryServerInstanceResource(sapDiscoveryServerInstanceResourceId);

            // invoke the operation
            SapDiscoveryServerInstanceResource result = await sapDiscoveryServerInstance.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SapDiscoveryServerInstanceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Updates the Server Instance resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdatesTheServerInstanceResource()
        {
            // Generated from example definition: specification/workloads/resource-manager/Microsoft.Workloads/SAPDiscoverySites/preview/2023-10-01-preview/examples/ServerInstances_Update.json
            // this example is just showing the usage of "ServerInstances_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SapDiscoveryServerInstanceResource created on azure
            // for more information of creating SapDiscoveryServerInstanceResource, please refer to the document of SapDiscoveryServerInstanceResource
            string subscriptionId = "6d875e77-e412-4d7d-9af4-8895278b4443";
            string resourceGroupName = "test-rg";
            string sapDiscoverySiteName = "SampleSite";
            string sapInstanceName = "MPP_MPP";
            string serverInstanceName = "APP_SapServer1";
            ResourceIdentifier sapDiscoveryServerInstanceResourceId = SapDiscoveryServerInstanceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, sapDiscoverySiteName, sapInstanceName, serverInstanceName);
            SapDiscoveryServerInstanceResource sapDiscoveryServerInstance = client.GetSapDiscoveryServerInstanceResource(sapDiscoveryServerInstanceResourceId);

            // invoke the operation
            SapDiscoveryServerInstancePatch patch = new SapDiscoveryServerInstancePatch()
            {
                Properties = new ServerInstanceProperties(),
            };
            SapDiscoveryServerInstanceResource result = await sapDiscoveryServerInstance.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SapDiscoveryServerInstanceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Deletes the Server Instance resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeletesTheServerInstanceResource()
        {
            // Generated from example definition: specification/workloads/resource-manager/Microsoft.Workloads/SAPDiscoverySites/preview/2023-10-01-preview/examples/ServerInstances_Delete.json
            // this example is just showing the usage of "ServerInstances_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SapDiscoveryServerInstanceResource created on azure
            // for more information of creating SapDiscoveryServerInstanceResource, please refer to the document of SapDiscoveryServerInstanceResource
            string subscriptionId = "6d875e77-e412-4d7d-9af4-8895278b4443";
            string resourceGroupName = "test-rg";
            string sapDiscoverySiteName = "SampleSite";
            string sapInstanceName = "MPP_MPP";
            string serverInstanceName = "APP_SapServer1";
            ResourceIdentifier sapDiscoveryServerInstanceResourceId = SapDiscoveryServerInstanceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, sapDiscoverySiteName, sapInstanceName, serverInstanceName);
            SapDiscoveryServerInstanceResource sapDiscoveryServerInstance = client.GetSapDiscoveryServerInstanceResource(sapDiscoveryServerInstanceResourceId);

            // invoke the operation
            await sapDiscoveryServerInstance.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
