// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> The WholeMetricConfigurationPatch. </summary>
    internal partial class WholeMetricConfigurationPatch
    {
        /// <summary> Initializes a new instance of <see cref="WholeMetricConfigurationPatch"/>. </summary>
        public WholeMetricConfigurationPatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="WholeMetricConfigurationPatch"/>. </summary>
        /// <param name="conditionOperator">
        /// condition operator
        ///
        /// should be specified when combining multiple detection conditions
        /// </param>
        /// <param name="smartDetectionCondition"></param>
        /// <param name="hardThresholdCondition"></param>
        /// <param name="changeThresholdCondition"></param>
        internal WholeMetricConfigurationPatch(DetectionConditionOperator? conditionOperator, SmartDetectionConditionPatch smartDetectionCondition, HardThresholdConditionPatch hardThresholdCondition, ChangeThresholdConditionPatch changeThresholdCondition)
        {
            ConditionOperator = conditionOperator;
            SmartDetectionCondition = smartDetectionCondition;
            HardThresholdCondition = hardThresholdCondition;
            ChangeThresholdCondition = changeThresholdCondition;
        }

        /// <summary>
        /// condition operator
        ///
        /// should be specified when combining multiple detection conditions
        /// </summary>
        public DetectionConditionOperator? ConditionOperator { get; set; }
        /// <summary> Gets or sets the smart detection condition. </summary>
        public SmartDetectionConditionPatch SmartDetectionCondition { get; set; }
        /// <summary> Gets or sets the hard threshold condition. </summary>
        public HardThresholdConditionPatch HardThresholdCondition { get; set; }
        /// <summary> Gets or sets the change threshold condition. </summary>
        public ChangeThresholdConditionPatch ChangeThresholdCondition { get; set; }
    }
}
