// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> The ServicePrincipalParam. </summary>
    internal partial class ServicePrincipalParam
    {
        /// <summary> Initializes a new instance of <see cref="ServicePrincipalParam"/>. </summary>
        /// <param name="clientId"> The client id of the service principal. </param>
        /// <param name="tenantId"> The tenant id of the service principal. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientId"/> or <paramref name="tenantId"/> is null. </exception>
        public ServicePrincipalParam(string clientId, string tenantId)
        {
            Argument.AssertNotNull(clientId, nameof(clientId));
            Argument.AssertNotNull(tenantId, nameof(tenantId));

            ClientId = clientId;
            TenantId = tenantId;
        }

        /// <summary> Initializes a new instance of <see cref="ServicePrincipalParam"/>. </summary>
        /// <param name="clientId"> The client id of the service principal. </param>
        /// <param name="clientSecret"> The client secret of the service principal. </param>
        /// <param name="tenantId"> The tenant id of the service principal. </param>
        internal ServicePrincipalParam(string clientId, string clientSecret, string tenantId)
        {
            ClientId = clientId;
            ClientSecret = clientSecret;
            TenantId = tenantId;
        }

        /// <summary> The client id of the service principal. </summary>
        public string ClientId { get; set; }
        /// <summary> The client secret of the service principal. </summary>
        public string ClientSecret { get; set; }
        /// <summary> The tenant id of the service principal. </summary>
        public string TenantId { get; set; }
    }
}
