// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> The ServicePrincipalInKVParamPatch. </summary>
    internal partial class ServicePrincipalInKVParamPatch
    {
        /// <summary> Initializes a new instance of <see cref="ServicePrincipalInKVParamPatch"/>. </summary>
        public ServicePrincipalInKVParamPatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ServicePrincipalInKVParamPatch"/>. </summary>
        /// <param name="keyVaultEndpoint"> The Key Vault endpoint that storing the service principal. </param>
        /// <param name="keyVaultClientId"> The Client Id to access the Key Vault. </param>
        /// <param name="keyVaultClientSecret"> The Client Secret to access the Key Vault. </param>
        /// <param name="servicePrincipalIdNameInKV"> The secret name of the service principal's client Id in the Key Vault. </param>
        /// <param name="servicePrincipalSecretNameInKV"> The secret name of the service principal's client secret in the Key Vault. </param>
        /// <param name="tenantId"> The tenant id of your service principal. </param>
        internal ServicePrincipalInKVParamPatch(string keyVaultEndpoint, string keyVaultClientId, string keyVaultClientSecret, string servicePrincipalIdNameInKV, string servicePrincipalSecretNameInKV, string tenantId)
        {
            KeyVaultEndpoint = keyVaultEndpoint;
            KeyVaultClientId = keyVaultClientId;
            KeyVaultClientSecret = keyVaultClientSecret;
            ServicePrincipalIdNameInKV = servicePrincipalIdNameInKV;
            ServicePrincipalSecretNameInKV = servicePrincipalSecretNameInKV;
            TenantId = tenantId;
        }

        /// <summary> The Key Vault endpoint that storing the service principal. </summary>
        public string KeyVaultEndpoint { get; set; }
        /// <summary> The Client Id to access the Key Vault. </summary>
        public string KeyVaultClientId { get; set; }
        /// <summary> The Client Secret to access the Key Vault. </summary>
        public string KeyVaultClientSecret { get; set; }
        /// <summary> The secret name of the service principal's client Id in the Key Vault. </summary>
        public string ServicePrincipalIdNameInKV { get; set; }
        /// <summary> The secret name of the service principal's client secret in the Key Vault. </summary>
        public string ServicePrincipalSecretNameInKV { get; set; }
        /// <summary> The tenant id of your service principal. </summary>
        public string TenantId { get; set; }
    }
}
