// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.AI.MetricsAdvisor.Models
{
    internal partial class SeriesResultList
    {
        internal static SeriesResultList DeserializeSeriesResultList(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<MetricEnrichedSeriesData> value = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("value"u8))
                {
                    List<MetricEnrichedSeriesData> array = new List<MetricEnrichedSeriesData>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MetricEnrichedSeriesData.DeserializeMetricEnrichedSeriesData(item));
                    }
                    value = array;
                    continue;
                }
            }
            return new SeriesResultList(value);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SeriesResultList FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSeriesResultList(document.RootElement);
        }
    }
}
