// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.AI.MetricsAdvisor.Models
{
    internal partial class RootCauseList
    {
        internal static RootCauseList DeserializeRootCauseList(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<IncidentRootCause> value = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("value"u8))
                {
                    List<IncidentRootCause> array = new List<IncidentRootCause>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(IncidentRootCause.DeserializeIncidentRootCause(item));
                    }
                    value = array;
                    continue;
                }
            }
            return new RootCauseList(value);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static RootCauseList FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeRootCauseList(document.RootElement);
        }
    }
}
