// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.AI.MetricsAdvisor.Models
{
    internal partial class MetricSeriesList
    {
        internal static MetricSeriesList DeserializeMetricSeriesList(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string nextLink = default;
            IReadOnlyList<MetricSeriesDefinition> value = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("@nextLink"u8))
                {
                    nextLink = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("value"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MetricSeriesDefinition> array = new List<MetricSeriesDefinition>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MetricSeriesDefinition.DeserializeMetricSeriesDefinition(item));
                    }
                    value = array;
                    continue;
                }
            }
            return new MetricSeriesList(nextLink, value ?? new ChangeTrackingList<MetricSeriesDefinition>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static MetricSeriesList FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeMetricSeriesList(document.RootElement);
        }
    }
}
