// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> The MetricDataItem. </summary>
    public partial class MetricSeriesData
    {
        /// <summary> Initializes a new instance of <see cref="MetricSeriesData"/>. </summary>
        /// <param name="definition"></param>
        /// <param name="timestamps"> timestamps of the data related to this time series. </param>
        /// <param name="metricValues"> values of the data related to this time series. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="definition"/> is null. </exception>
        internal MetricSeriesData(MetricSeriesDefinition definition, IEnumerable<DateTimeOffset> timestamps, IEnumerable<double> metricValues)
        {
            Argument.AssertNotNull(definition, nameof(definition));

            Definition = definition;
            Timestamps = timestamps.ToList();
            MetricValues = metricValues.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="MetricSeriesData"/>. </summary>
        /// <param name="definition"></param>
        /// <param name="timestamps"> timestamps of the data related to this time series. </param>
        /// <param name="metricValues"> values of the data related to this time series. </param>
        internal MetricSeriesData(MetricSeriesDefinition definition, IReadOnlyList<DateTimeOffset> timestamps, IReadOnlyList<double> metricValues)
        {
            Definition = definition;
            Timestamps = timestamps;
            MetricValues = metricValues;
        }
    }
}
