// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.AI.MetricsAdvisor.Models
{
    internal partial class MetricFeedbackList
    {
        internal static MetricFeedbackList DeserializeMetricFeedbackList(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string nextLink = default;
            IReadOnlyList<MetricFeedback> value = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("@nextLink"u8))
                {
                    nextLink = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("value"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MetricFeedback> array = new List<MetricFeedback>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MetricFeedback.DeserializeMetricFeedback(item));
                    }
                    value = array;
                    continue;
                }
            }
            return new MetricFeedbackList(nextLink, value ?? new ChangeTrackingList<MetricFeedback>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static MetricFeedbackList FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeMetricFeedbackList(document.RootElement);
        }
    }
}
