// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> The MetricDimensionQueryOptions. </summary>
    internal partial class MetricDimensionQueryOptions
    {
        /// <summary> Initializes a new instance of <see cref="MetricDimensionQueryOptions"/>. </summary>
        /// <param name="dimensionName"> dimension name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="dimensionName"/> is null. </exception>
        public MetricDimensionQueryOptions(string dimensionName)
        {
            Argument.AssertNotNull(dimensionName, nameof(dimensionName));

            DimensionName = dimensionName;
        }

        /// <summary> Initializes a new instance of <see cref="MetricDimensionQueryOptions"/>. </summary>
        /// <param name="dimensionName"> dimension name. </param>
        /// <param name="dimensionValueFilter"> dimension value to be filtered. </param>
        internal MetricDimensionQueryOptions(string dimensionName, string dimensionValueFilter)
        {
            DimensionName = dimensionName;
            DimensionValueFilter = dimensionValueFilter;
        }

        /// <summary> dimension name. </summary>
        public string DimensionName { get; }
        /// <summary> dimension value to be filtered. </summary>
        public string DimensionValueFilter { get; set; }
    }
}
