// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.AI.MetricsAdvisor.Models
{
    public partial class MetricBoundaryCondition : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(LowerBound))
            {
                writer.WritePropertyName("lower"u8);
                writer.WriteNumberValue(LowerBound.Value);
            }
            if (Optional.IsDefined(UpperBound))
            {
                writer.WritePropertyName("upper"u8);
                writer.WriteNumberValue(UpperBound.Value);
            }
            writer.WritePropertyName("direction"u8);
            writer.WriteStringValue(Direction.ToString());
            if (Optional.IsDefined(MeasureType))
            {
                writer.WritePropertyName("type"u8);
                writer.WriteStringValue(MeasureType.Value.ToString());
            }
            if (Optional.IsDefined(CompanionMetricId))
            {
                writer.WritePropertyName("metricId"u8);
                writer.WriteStringValue(CompanionMetricId);
            }
            if (Optional.IsDefined(ShouldAlertIfDataPointMissing))
            {
                writer.WritePropertyName("triggerForMissing"u8);
                writer.WriteBooleanValue(ShouldAlertIfDataPointMissing.Value);
            }
            writer.WriteEndObject();
        }

        internal static MetricBoundaryCondition DeserializeMetricBoundaryCondition(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            double? lower = default;
            double? upper = default;
            BoundaryDirection direction = default;
            BoundaryMeasureType? type = default;
            string metricId = default;
            bool? triggerForMissing = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("lower"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lower = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("upper"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    upper = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("direction"u8))
                {
                    direction = new BoundaryDirection(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    type = new BoundaryMeasureType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("metricId"u8))
                {
                    metricId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("triggerForMissing"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    triggerForMissing = property.Value.GetBoolean();
                    continue;
                }
            }
            return new MetricBoundaryCondition(
                lower,
                upper,
                direction,
                type,
                metricId,
                triggerForMissing);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static MetricBoundaryCondition FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeMetricBoundaryCondition(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
