// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.AI.MetricsAdvisor.Models
{
    public partial class MetricAnomalyAlertSnoozeCondition : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("autoSnooze"u8);
            writer.WriteNumberValue(AutoSnooze);
            writer.WritePropertyName("snoozeScope"u8);
            writer.WriteStringValue(SnoozeScope.ToString());
            writer.WritePropertyName("onlyForSuccessive"u8);
            writer.WriteBooleanValue(IsOnlyForSuccessive);
            writer.WriteEndObject();
        }

        internal static MetricAnomalyAlertSnoozeCondition DeserializeMetricAnomalyAlertSnoozeCondition(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int autoSnooze = default;
            SnoozeScope snoozeScope = default;
            bool onlyForSuccessive = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("autoSnooze"u8))
                {
                    autoSnooze = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("snoozeScope"u8))
                {
                    snoozeScope = new SnoozeScope(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("onlyForSuccessive"u8))
                {
                    onlyForSuccessive = property.Value.GetBoolean();
                    continue;
                }
            }
            return new MetricAnomalyAlertSnoozeCondition(autoSnooze, snoozeScope, onlyForSuccessive);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static MetricAnomalyAlertSnoozeCondition FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeMetricAnomalyAlertSnoozeCondition(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
