// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.AI.MetricsAdvisor.Models
{
    public partial class MetricAlertConfiguration : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("anomalyDetectionConfigurationId"u8);
            writer.WriteStringValue(DetectionConfigurationId);
            writer.WritePropertyName("anomalyScopeType"u8);
            writer.WriteStringValue(AnomalyScopeType.ToString());
            if (Optional.IsDefined(UseDetectionResultToFilterAnomalies))
            {
                writer.WritePropertyName("negationOperation"u8);
                writer.WriteBooleanValue(UseDetectionResultToFilterAnomalies.Value);
            }
            if (Optional.IsDefined(DimensionAnomalyScope))
            {
                writer.WritePropertyName("dimensionAnomalyScope"u8);
                writer.WriteObjectValue<DimensionKey>(DimensionAnomalyScope);
            }
            if (Optional.IsDefined(TopNAnomalyScope))
            {
                writer.WritePropertyName("topNAnomalyScope"u8);
                writer.WriteObjectValue<TopNGroupScope>(TopNAnomalyScope);
            }
            if (Optional.IsDefined(SeverityFilter))
            {
                writer.WritePropertyName("severityFilter"u8);
                writer.WriteObjectValue<SeverityCondition>(SeverityFilter);
            }
            if (Optional.IsDefined(AlertSnoozeCondition))
            {
                writer.WritePropertyName("snoozeFilter"u8);
                writer.WriteObjectValue<MetricAnomalyAlertSnoozeCondition>(AlertSnoozeCondition);
            }
            if (Optional.IsDefined(ValueFilter))
            {
                writer.WritePropertyName("valueFilter"u8);
                writer.WriteObjectValue<MetricBoundaryCondition>(ValueFilter);
            }
            writer.WriteEndObject();
        }

        internal static MetricAlertConfiguration DeserializeMetricAlertConfiguration(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string anomalyDetectionConfigurationId = default;
            MetricAnomalyAlertScopeType anomalyScopeType = default;
            bool? negationOperation = default;
            DimensionKey dimensionAnomalyScope = default;
            TopNGroupScope topNAnomalyScope = default;
            SeverityCondition severityFilter = default;
            MetricAnomalyAlertSnoozeCondition snoozeFilter = default;
            MetricBoundaryCondition valueFilter = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("anomalyDetectionConfigurationId"u8))
                {
                    anomalyDetectionConfigurationId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("anomalyScopeType"u8))
                {
                    anomalyScopeType = new MetricAnomalyAlertScopeType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("negationOperation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    negationOperation = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("dimensionAnomalyScope"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dimensionAnomalyScope = DimensionKey.DeserializeDimensionKey(property.Value);
                    continue;
                }
                if (property.NameEquals("topNAnomalyScope"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    topNAnomalyScope = TopNGroupScope.DeserializeTopNGroupScope(property.Value);
                    continue;
                }
                if (property.NameEquals("severityFilter"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    severityFilter = SeverityCondition.DeserializeSeverityCondition(property.Value);
                    continue;
                }
                if (property.NameEquals("snoozeFilter"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    snoozeFilter = MetricAnomalyAlertSnoozeCondition.DeserializeMetricAnomalyAlertSnoozeCondition(property.Value);
                    continue;
                }
                if (property.NameEquals("valueFilter"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    valueFilter = MetricBoundaryCondition.DeserializeMetricBoundaryCondition(property.Value);
                    continue;
                }
            }
            return new MetricAlertConfiguration(
                anomalyDetectionConfigurationId,
                anomalyScopeType,
                negationOperation,
                dimensionAnomalyScope,
                topNAnomalyScope,
                severityFilter,
                snoozeFilter,
                valueFilter);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static MetricAlertConfiguration FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeMetricAlertConfiguration(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
