// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.AI.MetricsAdvisor.Models
{
    internal partial class IngestionStatusList
    {
        internal static IngestionStatusList DeserializeIngestionStatusList(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string nextLink = default;
            IReadOnlyList<DataFeedIngestionStatus> value = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("@nextLink"u8))
                {
                    nextLink = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("value"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DataFeedIngestionStatus> array = new List<DataFeedIngestionStatus>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DataFeedIngestionStatus.DeserializeDataFeedIngestionStatus(item));
                    }
                    value = array;
                    continue;
                }
            }
            return new IngestionStatusList(nextLink, value ?? new ChangeTrackingList<DataFeedIngestionStatus>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static IngestionStatusList FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeIngestionStatusList(document.RootElement);
        }
    }
}
