// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.AI.MetricsAdvisor.Models
{
    public partial class IncidentRootCause
    {
        internal static IncidentRootCause DeserializeIncidentRootCause(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DimensionKey rootCause = default;
            IReadOnlyList<string> path = default;
            double score = default;
            string description = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("rootCause"u8))
                {
                    rootCause = DimensionKey.DeserializeDimensionKey(property.Value);
                    continue;
                }
                if (property.NameEquals("path"u8))
                {
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    path = array;
                    continue;
                }
                if (property.NameEquals("score"u8))
                {
                    score = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("description"u8))
                {
                    description = property.Value.GetString();
                    continue;
                }
            }
            return new IncidentRootCause(rootCause, path, score, description);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static IncidentRootCause FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeIncidentRootCause(document.RootElement);
        }
    }
}
