// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.AI.MetricsAdvisor.Models
{
    internal partial class IncidentProperty
    {
        internal static IncidentProperty DeserializeIncidentProperty(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            AnomalySeverity maxSeverity = default;
            AnomalyIncidentStatus incidentStatus = default;
            double valueOfRootNode = default;
            double? expectedValueOfRootNode = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("maxSeverity"u8))
                {
                    maxSeverity = new AnomalySeverity(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("incidentStatus"u8))
                {
                    incidentStatus = new AnomalyIncidentStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("valueOfRootNode"u8))
                {
                    valueOfRootNode = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("expectedValueOfRootNode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        expectedValueOfRootNode = null;
                        continue;
                    }
                    expectedValueOfRootNode = property.Value.GetDouble();
                    continue;
                }
            }
            return new IncidentProperty(maxSeverity, incidentStatus, valueOfRootNode, expectedValueOfRootNode);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static IncidentProperty FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeIncidentProperty(document.RootElement);
        }
    }
}
