// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.AI.MetricsAdvisor.Administration;

namespace Azure.AI.MetricsAdvisor.Models
{
    internal partial class HookList
    {
        internal static HookList DeserializeHookList(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string nextLink = default;
            IReadOnlyList<NotificationHook> value = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("@nextLink"u8))
                {
                    nextLink = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("value"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<NotificationHook> array = new List<NotificationHook>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(NotificationHook.DeserializeNotificationHook(item));
                    }
                    value = array;
                    continue;
                }
            }
            return new HookList(nextLink, value ?? new ChangeTrackingList<NotificationHook>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static HookList FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeHookList(document.RootElement);
        }
    }
}
