// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> The HardThresholdConditionPatch. </summary>
    internal partial class HardThresholdConditionPatch
    {
        /// <summary> Initializes a new instance of <see cref="HardThresholdConditionPatch"/>. </summary>
        public HardThresholdConditionPatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HardThresholdConditionPatch"/>. </summary>
        /// <param name="lowerBound">
        /// lower bound
        ///
        /// should be specified when anomalyDetectorDirection is Both or Down
        /// </param>
        /// <param name="upperBound">
        /// upper bound
        ///
        /// should be specified when anomalyDetectorDirection is Both or Up
        /// </param>
        /// <param name="anomalyDetectorDirection"> detection direction. </param>
        /// <param name="suppressCondition"></param>
        internal HardThresholdConditionPatch(double? lowerBound, double? upperBound, AnomalyDetectorDirection? anomalyDetectorDirection, SuppressConditionPatch suppressCondition)
        {
            LowerBound = lowerBound;
            UpperBound = upperBound;
            AnomalyDetectorDirection = anomalyDetectorDirection;
            SuppressCondition = suppressCondition;
        }

        /// <summary>
        /// lower bound
        ///
        /// should be specified when anomalyDetectorDirection is Both or Down
        /// </summary>
        public double? LowerBound { get; set; }
        /// <summary>
        /// upper bound
        ///
        /// should be specified when anomalyDetectorDirection is Both or Up
        /// </summary>
        public double? UpperBound { get; set; }
        /// <summary> detection direction. </summary>
        public AnomalyDetectorDirection? AnomalyDetectorDirection { get; set; }
        /// <summary> Gets or sets the suppress condition. </summary>
        public SuppressConditionPatch SuppressCondition { get; set; }
    }
}
