// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary>
    /// The DataSourceCredentialPatch.
    /// Please note <see cref="DataSourceCredentialPatch"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="AzureSQLConnectionStringCredentialPatch"/>, <see cref="DataLakeGen2SharedKeyCredentialPatch"/>, <see cref="ServicePrincipalCredentialPatch"/> and <see cref="ServicePrincipalInKVCredentialPatch"/>.
    /// </summary>
    internal partial class DataSourceCredentialPatch
    {
        /// <summary> Initializes a new instance of <see cref="DataSourceCredentialPatch"/>. </summary>
        public DataSourceCredentialPatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataSourceCredentialPatch"/>. </summary>
        /// <param name="dataSourceCredentialType"> Type of data source credential. </param>
        /// <param name="dataSourceCredentialName"> Name of data source credential. </param>
        /// <param name="dataSourceCredentialDescription"> Description of data source credential. </param>
        internal DataSourceCredentialPatch(DataSourceCredentialKind dataSourceCredentialType, string dataSourceCredentialName, string dataSourceCredentialDescription)
        {
            DataSourceCredentialType = dataSourceCredentialType;
            DataSourceCredentialName = dataSourceCredentialName;
            DataSourceCredentialDescription = dataSourceCredentialDescription;
        }

        /// <summary> Type of data source credential. </summary>
        internal DataSourceCredentialKind DataSourceCredentialType { get; set; }
        /// <summary> Name of data source credential. </summary>
        public string DataSourceCredentialName { get; set; }
        /// <summary> Description of data source credential. </summary>
        public string DataSourceCredentialDescription { get; set; }
    }
}
