// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.AI.MetricsAdvisor.Administration;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> The DataSourceCredentialList. </summary>
    internal partial class DataSourceCredentialList
    {
        /// <summary> Initializes a new instance of <see cref="DataSourceCredentialList"/>. </summary>
        internal DataSourceCredentialList()
        {
            Value = new ChangeTrackingList<DataSourceCredentialEntity>();
        }

        /// <summary> Initializes a new instance of <see cref="DataSourceCredentialList"/>. </summary>
        /// <param name="nextLink"></param>
        /// <param name="value">
        /// Please note <see cref="DataSourceCredentialEntity"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="SqlConnectionStringCredentialEntity"/>, <see cref="DataLakeSharedKeyCredentialEntity"/>, <see cref="ServicePrincipalCredentialEntity"/> and <see cref="ServicePrincipalInKeyVaultCredentialEntity"/>.
        /// </param>
        internal DataSourceCredentialList(string nextLink, IReadOnlyList<DataSourceCredentialEntity> value)
        {
            NextLink = nextLink;
            Value = value;
        }

        /// <summary> Gets the next link. </summary>
        public string NextLink { get; }
        /// <summary>
        /// Gets the value
        /// Please note <see cref="DataSourceCredentialEntity"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="SqlConnectionStringCredentialEntity"/>, <see cref="DataLakeSharedKeyCredentialEntity"/>, <see cref="ServicePrincipalCredentialEntity"/> and <see cref="ServicePrincipalInKeyVaultCredentialEntity"/>.
        /// </summary>
        public IReadOnlyList<DataSourceCredentialEntity> Value { get; }
    }
}
