// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.AI.MetricsAdvisor.Administration;

namespace Azure.AI.MetricsAdvisor.Models
{
    internal partial class DataSourceCredentialList
    {
        internal static DataSourceCredentialList DeserializeDataSourceCredentialList(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string nextLink = default;
            IReadOnlyList<DataSourceCredentialEntity> value = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("@nextLink"u8))
                {
                    nextLink = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("value"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DataSourceCredentialEntity> array = new List<DataSourceCredentialEntity>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DataSourceCredentialEntity.DeserializeDataSourceCredentialEntity(item));
                    }
                    value = array;
                    continue;
                }
            }
            return new DataSourceCredentialList(nextLink, value ?? new ChangeTrackingList<DataSourceCredentialEntity>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DataSourceCredentialList FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDataSourceCredentialList(document.RootElement);
        }
    }
}
