// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> Type of data source credential. </summary>
    public readonly partial struct DataSourceCredentialKind : IEquatable<DataSourceCredentialKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataSourceCredentialKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataSourceCredentialKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SqlConnectionStringValue = "AzureSQLConnectionString";
        private const string DataLakeSharedKeyValue = "DataLakeGen2SharedKey";
        private const string ServicePrincipalValue = "ServicePrincipal";
        private const string ServicePrincipalInKeyVaultValue = "ServicePrincipalInKV";
        /// <summary> Determines if two <see cref="DataSourceCredentialKind"/> values are the same. </summary>
        public static bool operator ==(DataSourceCredentialKind left, DataSourceCredentialKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataSourceCredentialKind"/> values are not the same. </summary>
        public static bool operator !=(DataSourceCredentialKind left, DataSourceCredentialKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataSourceCredentialKind"/>. </summary>
        public static implicit operator DataSourceCredentialKind(string value) => new DataSourceCredentialKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataSourceCredentialKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataSourceCredentialKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
