// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> data feed status. </summary>
    public readonly partial struct DataFeedStatus : IEquatable<DataFeedStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataFeedStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataFeedStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string PausedValue = "Paused";
        /// <summary> Determines if two <see cref="DataFeedStatus"/> values are the same. </summary>
        public static bool operator ==(DataFeedStatus left, DataFeedStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataFeedStatus"/> values are not the same. </summary>
        public static bool operator !=(DataFeedStatus left, DataFeedStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataFeedStatus"/>. </summary>
        public static implicit operator DataFeedStatus(string value) => new DataFeedStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataFeedStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataFeedStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
