// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> data source type. </summary>
    public readonly partial struct DataFeedSourceKind : IEquatable<DataFeedSourceKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataFeedSourceKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataFeedSourceKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureApplicationInsightsValue = "AzureApplicationInsights";
        private const string AzureBlobValue = "AzureBlob";
        private const string AzureCosmosDbValue = "AzureCosmosDB";
        private const string AzureDataExplorerValue = "AzureDataExplorer";
        private const string AzureDataLakeStorageValue = "AzureDataLakeStorageGen2";
        private const string AzureEventHubsValue = "AzureEventHubs";
        private const string LogAnalyticsValue = "AzureLogAnalytics";
        private const string AzureTableValue = "AzureTable";
        private const string InfluxDbValue = "InfluxDB";
        private const string MongoDbValue = "MongoDB";
        private const string MySqlValue = "MySql";
        private const string PostgreSqlValue = "PostgreSql";
        private const string SqlServerValue = "SqlServer";
        /// <summary> Determines if two <see cref="DataFeedSourceKind"/> values are the same. </summary>
        public static bool operator ==(DataFeedSourceKind left, DataFeedSourceKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataFeedSourceKind"/> values are not the same. </summary>
        public static bool operator !=(DataFeedSourceKind left, DataFeedSourceKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataFeedSourceKind"/>. </summary>
        public static implicit operator DataFeedSourceKind(string value) => new DataFeedSourceKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataFeedSourceKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataFeedSourceKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
