// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> the type of fill missing point for anomaly detection. </summary>
    public readonly partial struct DataFeedMissingDataPointFillType : IEquatable<DataFeedMissingDataPointFillType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataFeedMissingDataPointFillType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataFeedMissingDataPointFillType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SmartFillingValue = "SmartFilling";
        private const string PreviousValueValue = "PreviousValue";
        private const string CustomValueValue = "CustomValue";
        private const string NoFillingValue = "NoFilling";
        /// <summary> Determines if two <see cref="DataFeedMissingDataPointFillType"/> values are the same. </summary>
        public static bool operator ==(DataFeedMissingDataPointFillType left, DataFeedMissingDataPointFillType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataFeedMissingDataPointFillType"/> values are not the same. </summary>
        public static bool operator !=(DataFeedMissingDataPointFillType left, DataFeedMissingDataPointFillType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataFeedMissingDataPointFillType"/>. </summary>
        public static implicit operator DataFeedMissingDataPointFillType(string value) => new DataFeedMissingDataPointFillType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataFeedMissingDataPointFillType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataFeedMissingDataPointFillType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
