// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;

namespace Azure.AI.MetricsAdvisor.Models
{
    public partial class DataFeedIngestionProgress
    {
        internal static DataFeedIngestionProgress DeserializeDataFeedIngestionProgress(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DateTimeOffset? latestSuccessTimestamp = default;
            DateTimeOffset? latestActiveTimestamp = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("latestSuccessTimestamp"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        latestSuccessTimestamp = null;
                        continue;
                    }
                    latestSuccessTimestamp = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("latestActiveTimestamp"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        latestActiveTimestamp = null;
                        continue;
                    }
                    latestActiveTimestamp = property.Value.GetDateTimeOffset("O");
                    continue;
                }
            }
            return new DataFeedIngestionProgress(latestSuccessTimestamp, latestActiveTimestamp);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DataFeedIngestionProgress FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDataFeedIngestionProgress(document.RootElement);
        }
    }
}
