// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> granularity of the time series. </summary>
    public readonly partial struct DataFeedGranularityType : IEquatable<DataFeedGranularityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataFeedGranularityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataFeedGranularityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string YearlyValue = "Yearly";
        private const string MonthlyValue = "Monthly";
        private const string WeeklyValue = "Weekly";
        private const string DailyValue = "Daily";
        private const string HourlyValue = "Hourly";
        private const string PerMinuteValue = "Minutely";
        private const string CustomValue = "Custom";
        /// <summary> Determines if two <see cref="DataFeedGranularityType"/> values are the same. </summary>
        public static bool operator ==(DataFeedGranularityType left, DataFeedGranularityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataFeedGranularityType"/> values are not the same. </summary>
        public static bool operator !=(DataFeedGranularityType left, DataFeedGranularityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataFeedGranularityType"/>. </summary>
        public static implicit operator DataFeedGranularityType(string value) => new DataFeedGranularityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataFeedGranularityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataFeedGranularityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
