// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.AI.MetricsAdvisor.Models
{
    internal partial class DataFeedDetail : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("dataSourceType"u8);
            writer.WriteStringValue(DataSourceType.ToString());
            writer.WritePropertyName("dataFeedName"u8);
            writer.WriteStringValue(DataFeedName);
            if (Optional.IsDefined(DataFeedDescription))
            {
                writer.WritePropertyName("dataFeedDescription"u8);
                writer.WriteStringValue(DataFeedDescription);
            }
            writer.WritePropertyName("granularityName"u8);
            writer.WriteStringValue(GranularityName.ToString());
            if (Optional.IsDefined(GranularityAmount))
            {
                if (GranularityAmount != null)
                {
                    writer.WritePropertyName("granularityAmount"u8);
                    writer.WriteNumberValue(GranularityAmount.Value);
                }
                else
                {
                    writer.WriteNull("granularityAmount");
                }
            }
            writer.WritePropertyName("metrics"u8);
            writer.WriteStartArray();
            foreach (var item in Metrics)
            {
                writer.WriteObjectValue(item);
            }
            writer.WriteEndArray();
            if (Optional.IsCollectionDefined(Dimension))
            {
                writer.WritePropertyName("dimension"u8);
                writer.WriteStartArray();
                foreach (var item in Dimension)
                {
                    writer.WriteObjectValue<DataFeedDimension>(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(TimestampColumn))
            {
                writer.WritePropertyName("timestampColumn"u8);
                writer.WriteStringValue(TimestampColumn);
            }
            writer.WritePropertyName("dataStartFrom"u8);
            writer.WriteStringValue(DataStartFrom, "O");
            if (Optional.IsDefined(StartOffsetInSeconds))
            {
                writer.WritePropertyName("startOffsetInSeconds"u8);
                writer.WriteNumberValue(StartOffsetInSeconds.Value);
            }
            if (Optional.IsDefined(MaxConcurrency))
            {
                writer.WritePropertyName("maxConcurrency"u8);
                writer.WriteNumberValue(MaxConcurrency.Value);
            }
            if (Optional.IsDefined(MinRetryIntervalInSeconds))
            {
                writer.WritePropertyName("minRetryIntervalInSeconds"u8);
                writer.WriteNumberValue(MinRetryIntervalInSeconds.Value);
            }
            if (Optional.IsDefined(StopRetryAfterInSeconds))
            {
                writer.WritePropertyName("stopRetryAfterInSeconds"u8);
                writer.WriteNumberValue(StopRetryAfterInSeconds.Value);
            }
            if (Optional.IsDefined(NeedRollup))
            {
                writer.WritePropertyName("needRollup"u8);
                writer.WriteStringValue(NeedRollup.Value.ToString());
            }
            if (Optional.IsDefined(RollUpMethod))
            {
                writer.WritePropertyName("rollUpMethod"u8);
                writer.WriteStringValue(RollUpMethod.Value.ToString());
            }
            if (Optional.IsCollectionDefined(RollUpColumns))
            {
                writer.WritePropertyName("rollUpColumns"u8);
                writer.WriteStartArray();
                foreach (var item in RollUpColumns)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(AllUpIdentification))
            {
                writer.WritePropertyName("allUpIdentification"u8);
                writer.WriteStringValue(AllUpIdentification);
            }
            if (Optional.IsDefined(FillMissingPointType))
            {
                writer.WritePropertyName("fillMissingPointType"u8);
                writer.WriteStringValue(FillMissingPointType.Value.ToString());
            }
            if (Optional.IsDefined(FillMissingPointValue))
            {
                writer.WritePropertyName("fillMissingPointValue"u8);
                writer.WriteNumberValue(FillMissingPointValue.Value);
            }
            if (Optional.IsDefined(ViewMode))
            {
                writer.WritePropertyName("viewMode"u8);
                writer.WriteStringValue(ViewMode.Value.ToString());
            }
            if (Optional.IsCollectionDefined(Admins))
            {
                writer.WritePropertyName("admins"u8);
                writer.WriteStartArray();
                foreach (var item in Admins)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Viewers))
            {
                writer.WritePropertyName("viewers"u8);
                writer.WriteStartArray();
                foreach (var item in Viewers)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(ActionLinkTemplate))
            {
                writer.WritePropertyName("actionLinkTemplate"u8);
                writer.WriteStringValue(ActionLinkTemplate);
            }
            if (Optional.IsDefined(AuthenticationType))
            {
                writer.WritePropertyName("authenticationType"u8);
                writer.WriteStringValue(AuthenticationType.Value.ToString());
            }
            if (Optional.IsDefined(CredentialId))
            {
                writer.WritePropertyName("credentialId"u8);
                writer.WriteStringValue(CredentialId);
            }
            writer.WriteEndObject();
        }

        internal static DataFeedDetail DeserializeDataFeedDetail(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("dataSourceType", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "AzureApplicationInsights": return AzureApplicationInsightsDataFeed.DeserializeAzureApplicationInsightsDataFeed(element);
                    case "AzureBlob": return AzureBlobDataFeed.DeserializeAzureBlobDataFeed(element);
                    case "AzureCosmosDB": return AzureCosmosDBDataFeed.DeserializeAzureCosmosDBDataFeed(element);
                    case "AzureDataExplorer": return AzureDataExplorerDataFeed.DeserializeAzureDataExplorerDataFeed(element);
                    case "AzureDataLakeStorageGen2": return AzureDataLakeStorageGen2DataFeed.DeserializeAzureDataLakeStorageGen2DataFeed(element);
                    case "AzureEventHubs": return AzureEventHubsDataFeed.DeserializeAzureEventHubsDataFeed(element);
                    case "AzureLogAnalytics": return AzureLogAnalyticsDataFeed.DeserializeAzureLogAnalyticsDataFeed(element);
                    case "AzureTable": return AzureTableDataFeed.DeserializeAzureTableDataFeed(element);
                    case "InfluxDB": return InfluxDBDataFeed.DeserializeInfluxDBDataFeed(element);
                    case "MongoDB": return MongoDBDataFeed.DeserializeMongoDBDataFeed(element);
                    case "MySql": return MySqlDataFeed.DeserializeMySqlDataFeed(element);
                    case "PostgreSql": return PostgreSqlDataFeed.DeserializePostgreSqlDataFeed(element);
                    case "SqlServer": return SQLServerDataFeed.DeserializeSQLServerDataFeed(element);
                }
            }
            return UnknownDataFeedDetail.DeserializeUnknownDataFeedDetail(element);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DataFeedDetail FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDataFeedDetail(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
