// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> roll up method. </summary>
    public readonly partial struct DataFeedAutoRollupMethod : IEquatable<DataFeedAutoRollupMethod>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataFeedAutoRollupMethod"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataFeedAutoRollupMethod(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string SumValue = "Sum";
        private const string MaximumValue = "Max";
        private const string MinimumValue = "Min";
        private const string AverageValue = "Avg";
        private const string CountValue = "Count";
        /// <summary> Determines if two <see cref="DataFeedAutoRollupMethod"/> values are the same. </summary>
        public static bool operator ==(DataFeedAutoRollupMethod left, DataFeedAutoRollupMethod right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataFeedAutoRollupMethod"/> values are not the same. </summary>
        public static bool operator !=(DataFeedAutoRollupMethod left, DataFeedAutoRollupMethod right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataFeedAutoRollupMethod"/>. </summary>
        public static implicit operator DataFeedAutoRollupMethod(string value) => new DataFeedAutoRollupMethod(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataFeedAutoRollupMethod other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataFeedAutoRollupMethod other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
