// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> data feed access mode, default is Private. </summary>
    public readonly partial struct DataFeedAccessMode : IEquatable<DataFeedAccessMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataFeedAccessMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataFeedAccessMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PrivateValue = "Private";
        private const string PublicValue = "Public";
        /// <summary> Determines if two <see cref="DataFeedAccessMode"/> values are the same. </summary>
        public static bool operator ==(DataFeedAccessMode left, DataFeedAccessMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataFeedAccessMode"/> values are not the same. </summary>
        public static bool operator !=(DataFeedAccessMode left, DataFeedAccessMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataFeedAccessMode"/>. </summary>
        public static implicit operator DataFeedAccessMode(string value) => new DataFeedAccessMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataFeedAccessMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataFeedAccessMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
