// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.AI.MetricsAdvisor.Models
{
    public partial class ChangeThresholdCondition : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("changePercentage"u8);
            writer.WriteNumberValue(ChangePercentage);
            writer.WritePropertyName("shiftPoint"u8);
            writer.WriteNumberValue(ShiftPoint);
            writer.WritePropertyName("withinRange"u8);
            writer.WriteBooleanValue(WithinRange);
            writer.WritePropertyName("anomalyDetectorDirection"u8);
            writer.WriteStringValue(AnomalyDetectorDirection.ToString());
            writer.WritePropertyName("suppressCondition"u8);
            writer.WriteObjectValue<SuppressCondition>(SuppressCondition);
            writer.WriteEndObject();
        }

        internal static ChangeThresholdCondition DeserializeChangeThresholdCondition(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            double changePercentage = default;
            int shiftPoint = default;
            bool withinRange = default;
            AnomalyDetectorDirection anomalyDetectorDirection = default;
            SuppressCondition suppressCondition = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("changePercentage"u8))
                {
                    changePercentage = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("shiftPoint"u8))
                {
                    shiftPoint = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("withinRange"u8))
                {
                    withinRange = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("anomalyDetectorDirection"u8))
                {
                    anomalyDetectorDirection = new AnomalyDetectorDirection(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("suppressCondition"u8))
                {
                    suppressCondition = Models.SuppressCondition.DeserializeSuppressCondition(property.Value);
                    continue;
                }
            }
            return new ChangeThresholdCondition(changePercentage, shiftPoint, withinRange, anomalyDetectorDirection, suppressCondition);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ChangeThresholdCondition FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeChangeThresholdCondition(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
