// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> value filter direction. </summary>
    public readonly partial struct BoundaryDirection : IEquatable<BoundaryDirection>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BoundaryDirection"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BoundaryDirection(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BothValue = "Both";
        private const string DownValue = "Down";
        private const string UpValue = "Up";
        /// <summary> Determines if two <see cref="BoundaryDirection"/> values are the same. </summary>
        public static bool operator ==(BoundaryDirection left, BoundaryDirection right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BoundaryDirection"/> values are not the same. </summary>
        public static bool operator !=(BoundaryDirection left, BoundaryDirection right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BoundaryDirection"/>. </summary>
        public static implicit operator BoundaryDirection(string value) => new BoundaryDirection(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BoundaryDirection other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BoundaryDirection other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
