// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> The AzureEventHubsParameter. </summary>
    internal partial class AzureEventHubsParameter
    {
        /// <summary> Initializes a new instance of <see cref="AzureEventHubsParameter"/>. </summary>
        /// <param name="consumerGroup"> The consumer group to be used in this data feed. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="consumerGroup"/> is null. </exception>
        public AzureEventHubsParameter(string consumerGroup)
        {
            Argument.AssertNotNull(consumerGroup, nameof(consumerGroup));

            ConsumerGroup = consumerGroup;
        }

        /// <summary> Initializes a new instance of <see cref="AzureEventHubsParameter"/>. </summary>
        /// <param name="connectionString"> The connection string of this Azure Event Hubs. </param>
        /// <param name="consumerGroup"> The consumer group to be used in this data feed. </param>
        internal AzureEventHubsParameter(string connectionString, string consumerGroup)
        {
            ConnectionString = connectionString;
            ConsumerGroup = consumerGroup;
        }

        /// <summary> The connection string of this Azure Event Hubs. </summary>
        public string ConnectionString { get; set; }
        /// <summary> The consumer group to be used in this data feed. </summary>
        public string ConsumerGroup { get; set; }
    }
}
