// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.AI.MetricsAdvisor.Models
{
    internal partial class AzureDataLakeStorageGen2Parameter : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(AccountName))
            {
                if (AccountName != null)
                {
                    writer.WritePropertyName("accountName"u8);
                    writer.WriteStringValue(AccountName);
                }
                else
                {
                    writer.WriteNull("accountName");
                }
            }
            if (Optional.IsDefined(AccountKey))
            {
                if (AccountKey != null)
                {
                    writer.WritePropertyName("accountKey"u8);
                    writer.WriteStringValue(AccountKey);
                }
                else
                {
                    writer.WriteNull("accountKey");
                }
            }
            if (FileSystemName != null)
            {
                writer.WritePropertyName("fileSystemName"u8);
                writer.WriteStringValue(FileSystemName);
            }
            else
            {
                writer.WriteNull("fileSystemName");
            }
            if (DirectoryTemplate != null)
            {
                writer.WritePropertyName("directoryTemplate"u8);
                writer.WriteStringValue(DirectoryTemplate);
            }
            else
            {
                writer.WriteNull("directoryTemplate");
            }
            if (FileTemplate != null)
            {
                writer.WritePropertyName("fileTemplate"u8);
                writer.WriteStringValue(FileTemplate);
            }
            else
            {
                writer.WriteNull("fileTemplate");
            }
            writer.WriteEndObject();
        }

        internal static AzureDataLakeStorageGen2Parameter DeserializeAzureDataLakeStorageGen2Parameter(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string accountName = default;
            string accountKey = default;
            string fileSystemName = default;
            string directoryTemplate = default;
            string fileTemplate = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("accountName"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        accountName = null;
                        continue;
                    }
                    accountName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("accountKey"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        accountKey = null;
                        continue;
                    }
                    accountKey = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("fileSystemName"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        fileSystemName = null;
                        continue;
                    }
                    fileSystemName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("directoryTemplate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        directoryTemplate = null;
                        continue;
                    }
                    directoryTemplate = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("fileTemplate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        fileTemplate = null;
                        continue;
                    }
                    fileTemplate = property.Value.GetString();
                    continue;
                }
            }
            return new AzureDataLakeStorageGen2Parameter(accountName, accountKey, fileSystemName, directoryTemplate, fileTemplate);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AzureDataLakeStorageGen2Parameter FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAzureDataLakeStorageGen2Parameter(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
