// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> authentication type for corresponding data source. </summary>
    internal readonly partial struct AuthenticationTypeEnum : IEquatable<AuthenticationTypeEnum>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AuthenticationTypeEnum"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AuthenticationTypeEnum(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasicValue = "Basic";
        private const string ManagedIdentityValue = "ManagedIdentity";
        private const string AzureSQLConnectionStringValue = "AzureSQLConnectionString";
        private const string DataLakeGen2SharedKeyValue = "DataLakeGen2SharedKey";
        private const string ServicePrincipalValue = "ServicePrincipal";
        private const string ServicePrincipalInKVValue = "ServicePrincipalInKV";

        /// <summary> Basic. </summary>
        public static AuthenticationTypeEnum Basic { get; } = new AuthenticationTypeEnum(BasicValue);
        /// <summary> ManagedIdentity. </summary>
        public static AuthenticationTypeEnum ManagedIdentity { get; } = new AuthenticationTypeEnum(ManagedIdentityValue);
        /// <summary> AzureSQLConnectionString. </summary>
        public static AuthenticationTypeEnum AzureSQLConnectionString { get; } = new AuthenticationTypeEnum(AzureSQLConnectionStringValue);
        /// <summary> DataLakeGen2SharedKey. </summary>
        public static AuthenticationTypeEnum DataLakeGen2SharedKey { get; } = new AuthenticationTypeEnum(DataLakeGen2SharedKeyValue);
        /// <summary> ServicePrincipal. </summary>
        public static AuthenticationTypeEnum ServicePrincipal { get; } = new AuthenticationTypeEnum(ServicePrincipalValue);
        /// <summary> ServicePrincipalInKV. </summary>
        public static AuthenticationTypeEnum ServicePrincipalInKV { get; } = new AuthenticationTypeEnum(ServicePrincipalInKVValue);
        /// <summary> Determines if two <see cref="AuthenticationTypeEnum"/> values are the same. </summary>
        public static bool operator ==(AuthenticationTypeEnum left, AuthenticationTypeEnum right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AuthenticationTypeEnum"/> values are not the same. </summary>
        public static bool operator !=(AuthenticationTypeEnum left, AuthenticationTypeEnum right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AuthenticationTypeEnum"/>. </summary>
        public static implicit operator AuthenticationTypeEnum(string value) => new AuthenticationTypeEnum(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AuthenticationTypeEnum other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AuthenticationTypeEnum other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
