// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary>
    /// anomaly status
    ///
    /// only return for alerting anomaly result
    /// </summary>
    public readonly partial struct AnomalyStatus : IEquatable<AnomalyStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AnomalyStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AnomalyStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string ResolvedValue = "Resolved";
        /// <summary> Determines if two <see cref="AnomalyStatus"/> values are the same. </summary>
        public static bool operator ==(AnomalyStatus left, AnomalyStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnomalyStatus"/> values are not the same. </summary>
        public static bool operator !=(AnomalyStatus left, AnomalyStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AnomalyStatus"/>. </summary>
        public static implicit operator AnomalyStatus(string value) => new AnomalyStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnomalyStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnomalyStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
