// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> min alert severity. </summary>
    public readonly partial struct AnomalySeverity : IEquatable<AnomalySeverity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AnomalySeverity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AnomalySeverity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LowValue = "Low";
        private const string MediumValue = "Medium";
        private const string HighValue = "High";
        /// <summary> Determines if two <see cref="AnomalySeverity"/> values are the same. </summary>
        public static bool operator ==(AnomalySeverity left, AnomalySeverity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnomalySeverity"/> values are not the same. </summary>
        public static bool operator !=(AnomalySeverity left, AnomalySeverity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AnomalySeverity"/>. </summary>
        public static implicit operator AnomalySeverity(string value) => new AnomalySeverity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnomalySeverity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnomalySeverity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
