// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> The AnomalyResultList. </summary>
    internal partial class AnomalyResultList
    {
        /// <summary> Initializes a new instance of <see cref="AnomalyResultList"/>. </summary>
        /// <param name="value"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        internal AnomalyResultList(IEnumerable<DataPointAnomaly> value)
        {
            Argument.AssertNotNull(value, nameof(value));

            Value = value.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="AnomalyResultList"/>. </summary>
        /// <param name="nextLink"></param>
        /// <param name="value"></param>
        internal AnomalyResultList(string nextLink, IReadOnlyList<DataPointAnomaly> value)
        {
            NextLink = nextLink;
            Value = value;
        }

        /// <summary> Gets the next link. </summary>
        public string NextLink { get; }
        /// <summary> Gets the value. </summary>
        public IReadOnlyList<DataPointAnomaly> Value { get; }
    }
}
