// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.AI.MetricsAdvisor.Models
{
    /// <summary> The AnomalyProperty. </summary>
    internal partial class AnomalyProperty
    {
        /// <summary> Initializes a new instance of <see cref="AnomalyProperty"/>. </summary>
        /// <param name="anomalySeverity"> anomaly severity. </param>
        /// <param name="value"> value of the anomaly. </param>
        internal AnomalyProperty(AnomalySeverity anomalySeverity, double value)
        {
            AnomalySeverity = anomalySeverity;
            Value = value;
        }

        /// <summary> Initializes a new instance of <see cref="AnomalyProperty"/>. </summary>
        /// <param name="anomalySeverity"> anomaly severity. </param>
        /// <param name="anomalyStatus">
        /// anomaly status
        ///
        /// only return for alerting anomaly result
        /// </param>
        /// <param name="value"> value of the anomaly. </param>
        /// <param name="expectedValue"> expected value of the anomaly given by smart detector. </param>
        internal AnomalyProperty(AnomalySeverity anomalySeverity, AnomalyStatus? anomalyStatus, double value, double? expectedValue)
        {
            AnomalySeverity = anomalySeverity;
            AnomalyStatus = anomalyStatus;
            Value = value;
            ExpectedValue = expectedValue;
        }

        /// <summary> anomaly severity. </summary>
        public AnomalySeverity AnomalySeverity { get; }
        /// <summary>
        /// anomaly status
        ///
        /// only return for alerting anomaly result
        /// </summary>
        public AnomalyStatus? AnomalyStatus { get; }
        /// <summary> value of the anomaly. </summary>
        public double Value { get; }
        /// <summary> expected value of the anomaly given by smart detector. </summary>
        public double? ExpectedValue { get; }
    }
}
